.586
.model flat, stdcall
option casemap:none

; INCLUDES * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\gdi32.inc
include \masm32\include\masm32.inc
include .\glStuff\gl.def
include .\glStuff\glu.def
include .\glStuff\winextra.def

includelib c:\masm32\lib\kernel32.lib
includelib c:\masm32\lib\user32.lib
includelib c:\masm32\lib\gdi32.lib
includelib c:\masm32\lib\opengl32.lib
includelib c:\masm32\lib\glu32.lib
includelib c:\masm32\lib\masm32.lib

; Missing from include files * * * * * * * * * * * * * * * * * * * * * 
DM_BITSPERPEL       = 00040000h
DM_PELSWIDTH        = 00080000h
DM_PELSHEIGHT       = 00100000h
ANTIALIASED_QUALITY = 4
WGL_FONT_POLYGONS 	= 1

; PROTOTYPES * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
WinMain                      PROTO :HWND, :UINT, :WPARAM, :LPARAM
CreateGLWindow        PROTO :DWORD, :DWORD, :DWORD, :UINT, :BOOL
KillGLWindow             PROTO

.data
;
txt_Window_Title                 db "Homer's OpenGL TestBed",0
;
txt_Title_Fullscn                  db "Graphics mode",0
txt_Query_Fullscn               db "Do you want to run in fullscreen?",0
;
txt_WC_Failed	                     db "Failed to registed window class",0
txt_GL_Context_Failed         db "Failed to create a GL device context",0
txt_RC_Failed                       db "Failed to create a GL rendering context",0
txt_PixelFormat_Failed        db "Failed to find suitable PixelFormat",0
txt_ActivateRC_Failed	          db "Failed to activate GL rendering context",0
txt_GLInit_Failed                  db "Initialisation failed",0
txt_SetPixelFormat_Failed   db "Failed to set PixelFormat",0
txt_WindowCreateError        db "Window creation error",0
txt_Error                               db "Error",0
txt_OpenGL                          db "OpenGL",0

; UNINITIALISED DATA * * * * * * * * * * * * * * * * * * * * * * * * * 
.data?
hRC          HGLRC   ?
hDC          HDC         ?
hWnd       HWND        ?
hInstance HINSTANCE ?
;
keys               db 256 dup (?)             ; keypress status
fullscreen       BOOL  ?                      ; fullscreen toggle
active             BOOL  ?                      ; window active toggle/status

; BUGS BEGIN HERE * * * * * * * * * * * * * * * * * * * * * * * * * * 
.code
__DEBUG__ equ 0
include \masm32\include\macros.inc         ;<-- Homer's general-purpose macro include
include .\GLStuff\GLBase.inc                         ;<-- OpenGL-related code

start:
invoke GetModuleHandle,0
mov hInstance, eax
invoke WinMain,hInstance,0,0,0
invoke ExitProcess, eax
;** END

.code
;=========================================================================
WinMain proc hInst, hPrevInst, CmdLine, CmdShow
LOCAL msg:MSG, done:UINT
local buf[256]:BYTE
; Check	if we should start in full screen
    invoke MessageBox,NULL,addr	txt_Query_Fullscn,addr txt_Title_Fullscn,MB_YESNO or MB_ICONQUESTION
    .IF eax == IDNO
        mov fullscreen,FALSE
    .ELSE
        mov fullscreen,TRUE
    .ENDIF

    invoke CreateGLWindow,addr txt_Window_Title,640,480,16,fullscreen
    .IF !eax
        ret
    .ENDIF

    mov done,FALSE
    .WHILE !done
    invoke PeekMessage,addr	msg,NULL,0,0,PM_REMOVE
    .IF eax
        .IF msg.message == WM_QUIT
            mov done,TRUE
        .ELSE
            invoke TranslateMessage,addr msg
            invoke DispatchMessage,addr msg
        .ENDIF
    .ELSE
;---- BEGIN RENDERING CODE ----
      ;  invoke DrawGLScene      
        ;*** delete this line
        mov eax,TRUE
        .IF ((active) && (!eax)) || (keys[VK_ESCAPE])
            mov done, 1        
        .ELSE
            invoke SwapBuffers,hDC  ;<-- switching the front and back buffers displays the rendered frame
        .ENDIF
;----- END RENDERING CODE -----
	  		
; KEYBOARD - Check for some important keystrokes
        .IF keys[VK_F1]
            mov keys[VK_F1],FALSE
            invoke KillGLWindow
            xor fullscreen, 1
            invoke CreateGLWindow,addr txt_Window_Title,640,480,16,fullscreen
            .IF !eax
                mov eax,FALSE
            .ENDIF       
        .ENDIF

    .ENDIF
    .ENDW                           ;End of Main Loop (User has decided to QUIT TO WINDOWS)
    invoke KillGLWindow
    mov eax,msg.wParam
    ret
WinMain endp

WndProc proc hWind:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
local charz[2]:BYTE
    .IF uMsg == WM_ACTIVATE
        mov eax,wParam
        .IF !ah
            mov active,TRUE
        .ELSE
            mov active,FALSE
        .ENDIF
        xor eax, eax
        ret
    .ELSEIF uMsg==WM_SYSCOMMAND
        .IF wParam == SC_SCREENSAVE or SC_MONITORPOWER
            xor eax, eax
            ret
        .ENDIF
    .ELSEIF uMsg==WM_CLOSE
        invoke PostQuitMessage,0
        xor eax, eax
        ret
    .ELSEIF uMsg==WM_KEYDOWN
        mov eax,wParam
        mov keys[eax],TRUE
        xor eax, eax
        ret
    .ELSEIF uMsg==WM_KEYUP
        mov eax,wParam
        mov keys[eax],FALSE
        xor eax, eax
        ret

    .ELSEIF uMsg==WM_SIZE
        mov eax,lParam
        mov ebx,eax
        and eax,0000FFFFh
        shr ebx,16
        invoke ReSizeGLScene,eax,ebx
        xor eax, eax
        ret
    
    .ENDIF
    invoke DefWindowProc,hWind,uMsg,wParam,lParam
    ret
WndProc endp



end start