Matrix4By4Product proc uses esi edi ebx ecx eax pOut, pMat1, pMat2
local lLoop1, lLoop2
   mov esi, pMat1
   mov ebx, pOut
   mov ecx, 4

QLoop1:
   mov edx, 4
   mov edi, pMat2           ;<-- reset Source2 pointer
   fld dword ptr [esi]        ;<-- load the next Source1 Row
   fld dword ptr [esi+4]
   fld dword ptr [esi+8]
   fld dword ptr [esi+12]

QLoop2:
   fld dword ptr [edi]
   fmul st, st(4)
   fld dword ptr [edi+16]
   fmul st, st(4)
   faddp st(1), st
   fld dword ptr [edi+32]
   fmul st, st(3)
   faddp st(1), st
   fld dword ptr [edi+48]
   fmul st, st(2)
   faddp st(1), st
   fstp dword ptr [ebx]
   add edi, 4                    ;<-- increment Source2 pointer
   add ebx, 4                   ;<-- increment Target pointer
   dec edx
   jne QLoop2

   fld dword ptr [edi]
   fmulp st(4), st
   fld dword ptr [edi+16]
   fmulp st(3), st
   fld dword ptr [edi+32]
   fmulp st(2), st
   fld dword ptr [edi+48]
   fmulp st(1), st
   faddp st(2), st
   faddp st(2), st
   faddp st(1), st  
   fstp dword ptr [ebx]     ;<-- Store partial result
   add esi, 16                  ;<-- increment Source1 Row
   dec ecx
   jne QLoop1
   ret
Matrix4By4Product endp


facos MACRO fTheta
        fld fTheta       
        fmul st(0), st(0)      
        fld1 
        fsubr
        fsqrt 
        fxch 
        fpatan 
ENDM 

Vec3 struct
    X REAL4 ?
    Y REAL4 ?
    Z REAL4 ?
Vec3 ends

;This computes the dot product of 2 vectors
; ** WARNING ** The return value is on the FPU STACK
Vec3Dot proc uses esi edi pVector1, pVector2
; The dot product is this equation: V1.V2 = (V1.x * V2.x  +  V1.y * V2.y  +  V1.z * V2.z)
; In math terms, it looks like this:  V1.V2 = ||V1|| ||V2|| cos(theta).
; It returns the distance of the projected vector, vVector2, from the start of vVector1.
        mov esi,pVector1
        mov edi,pVector2
        fld [esi].Vec3.X
        fmul [edi].Vec3.X
        fld [esi].Vec3.Y
        fmul [edi].Vec3.Y
        fld [esi].Vec3.Z
        fmul [edi].Vec3.Z
        fadd
        fadd
        ret
Vec3Dot endp



;This proc calculates a perpendicular vector from 2 given vectors by taking the cross product.
;Returns in given buffer the cross product (Direction the polygon is facing - Normal)           
Vec3Cross proc uses ecx esi edi pVector1, pVector2 , pDest

; If we are given 2 vectors (directions of 2 sides of a polygon)
; then we have a plane define.  The cross product finds a vector that is perpendicular
; to that plane, which means it's point straight out of the plane at a 90 degree angle.
 
            mov esi,pVector1
            mov edi,pVector2
            mov ecx,pDest

; The X value for the vector is:  (V1.y * V2.z) - (V1.z * V2.y) 
; vNormal.x = ((vVector1.y * vVector2.z) - (vVector1.z * vVector2.y));
            fld [esi].Vec3.Y
            fmul [edi].Vec3.Z
            fld [esi].Vec3.Z
            fmul [edi].Vec3.Y
            fsub
            fstp [ecx].Vec3.X
              
; The Y value for the vector is:  (V1.z * V2.x) - (V1.x * V2.z)
; vNormal.y = ((vVector1.z * vVector2.x) - (vVector1.x * vVector2.z));
            fld [esi].Vec3.Z
            fmul [edi].Vec3.X
            fld [esi].Vec3.X
            fmul [edi].Vec3.Z
            fsub
            fstp [ecx].Vec3.Y
              
; The Z value for the vector is:  (V1.x * V2.y) - (V1.y * V2.x)
; vNormal.z = ((vVector1.x * vVector2.y) - (vVector1.y * vVector2.x));
            fld [esi].Vec3.X
            fmul [edi].Vec3.Y
            fld [esi].Vec3.Y
            fmul [edi].Vec3.X
            fsub
            fstp [ecx].Vec3.Z
 ret 
Vec3Cross endp

; This is the classic formula used in beginning algebra to return the
; distance between 2 points.  Since it's 3D, we just add the z dimension:
; Distance = sqrt(  (P2.x - P1.x)^2 + (P2.y - P1.y)^2 + (P2.z - P1.z)^2 )
; ** WARNING ** The return value is on the FPU STACK
Vec3Distance proc uses esi edi pPoint1, pPoint2
        mov esi,pPoint1
        mov edi,pPoint2
        fld    [edi].Vec3.X
        fsub [esi].Vec3.X
        fmul st(0), st(0)
        fld    [edi].Vec3.Y
        fsub [esi].Vec3.Y
        fmul st(0), st(0)
        fld    [edi].Vec3.Z
        fsub [esi].Vec3.Z
        fmul st(0), st(0)
        fadd
        fadd
        fsqrt
        ret
Vec3Distance endp

; This proc calculates the vector between 2 points
VectorFrom2Points proc uses ecx esi edi pPoint1, pPoint2, pDest
            mov esi, pPoint1
            mov edi,pPoint2

            xor eax,eax
            mov ecx,pDest
            mov [ecx].Vec3.X,eax
            mov [ecx].Vec3.Y,eax
            mov [ecx].Vec3.Z,eax

; In order to get a vector from 2 points (a direction) we need to
; subtract the second point from the first point.
            fld [esi].Vec3.X
            fsub [edi].Vec3.X
            fstp [ecx].Vec3.X
            fld [esi].Vec3.Y
            fsub [edi].Vec3.Y
            fstp [ecx].Vec3.Y
            fld [esi].Vec3.Z
            fsub [edi].Vec3.Z
            fstp [ecx].Vec3.Z
 ret
VectorFrom2Points endp


; This proc calcs the magnitude of a normal (or any other vector)
; ** WARNING ** The return value is on the FPU STACK
Vec3Magnitude proc uses esi pNormal
local hehe
; This will give us the magnitude or "Norm" as some say, of our normal.
; Here is the equation:  magnitude = sqrt(V.x^2 + V.y^2 + V.z^2)  Where V is the vector
        mov esi,pNormal
        fld [esi].Vec3.X
        fmul [esi].Vec3.X
        fld [esi].Vec3.Y
        fmul [esi].Vec3.Y
        fld [esi].Vec3.Z
        fmul [esi].Vec3.Z
        fadd
        fadd
        fsqrt
        ret
Vec3Magnitude endp

; This returns a normalize vector (A vector exactly of length 1)
Vec3Normalize proc uses esi pNormal
local fmag
        invoke Vec3Magnitude,pNormal            ; Get the magnitude of our normal
        fstp fmag

; Now that we have the magnitude, we can divide our normal by that magnitude.
; That will make our normal a total length of 1.  This makes it easier to work with too.
        mov esi,pNormal
        fld [esi].Vec3.X
        fdiv fmag
        fstp [esi].Vec3.X
        fld [esi].Vec3.Y
        fdiv fmag
        fstp [esi].Vec3.Y
        fld [esi].Vec3.Z
        fdiv fmag
        fstp [esi].Vec3.Z
        ret
Vec3Normalize endp

; This returns the normal of a polygon (The direction the polygon is facing)
Vec3Normal proc pTriangle, pDest
local vVector1[3]:FLOAT
local vVector2[3]:FLOAT
local vNormal[3]:FLOAT
; Get 2 vectors from the polygon (2 sides), Remember the order!
; (Triangles are 3 floats, ie, 12 bytes each)
            invoke VectorFrom2Points, pTriangle[2*12], pTriangle[0],addr vVector1
            invoke VectorFrom2Points, pTriangle[1*12], pTriangle[0],addr vVector2
; Take the cross product of our 2 vectors to get a perpendicular vector
            invoke Vec3Cross, addr vVector1, addr vVector2, pDest
; Now we have a normal, but it's at a strange length, so let's make it length 1.
            invoke Vec3Normalize, pDest
 ret
Vec3Normal endp

; This returns the distance between a plane and the origin
; ** WARNING ** The return value is on the FPU STACK
PlaneDistance proc uses esi edi pNormal, pPoint
; Use the plane equation to find the distance (Ax + By + Cz + D = 0)  We want to find D.
; For more information about the plane equation, read about it in the function below (IntersectedPlane())
; Basically, A B C is the X Y Z value of our normal and the x y z is our x y z of our point.
; D is the distance from the origin.  So, we need to move this equation around to find D.
; We come up with D = -(Ax + By + Cz)
; Basically, the negated dot product of the normal of the plane and the point.
        mov esi, pNormal
        mov edi, pPoint
        fld    [esi].Vec3.X
        fmul [edi].Vec3.X
        fld    [esi].Vec3.Y
        fmul [edi].Vec3.Y
        fld    [esi].Vec3.Z
        fmul [edi].Vec3.Z
        fadd
        fadd
        fchs
        ret
PlaneDistance endp


;This checks to see if a line intersects a plane
IntersectedPlane proc pTriangle, pLine
local fdistance1, fdistance2, foriginDistance 
local vNormal:Vec3
            mov eax,0
            mov fdistance1,eax
            mov fdistance2,eax
            invoke Vec3Normal, pTriangle,addr vNormal  ; We need to get the normal of our plane to go any further

; Now that we have the normal, we need to calculate the distance our triangle is from the origin.
; Since we would have the same triangle, but -10 down the z axis, we need to know
; how far our plane is to the origin.  The origin is (0, 0, 0), so we need to find
; the shortest distance our plane is from (0, 0, 0).  This way we can test the collision.
; The direction the plane is facing is important (We know this by the normal), but it's
; also important WHERE that plane is in our 3D space.  I hope this makes sense.

; We created a function to calculate the distance for us.  All we need is the normal
; of the plane, and then ANY point located on that plane.  Well, we have 3 points.  Each
; point of the triangle is on the plane, so we just pass in one of our points.  It doesn't
; matter which one, so we will just pass in the first one.  We get a single value back.
; That is the distance.  Just like our normalized normal is of length 1, our distance
; is a single value too.  It's like if you were to measure something with a ruler,
; you don't measure it according to the X Y and Z of our world, you just want ONE number.

            invoke PlaneDistance,addr vNormal, pTriangle
 fstp foriginDistance

; Now the next step is simple, but hard to understand at first.  What we need to
; do is get the distance of EACH point from out plane.  Above we got the distance of the
; plane to the point (0, 0, 0) which happens to be the origin, now we need to get a distance
; for each point.  If the distance is a negative number, then the point is BEHIND the plane.
; If the distance is positive, then the point is in front of the plane.  Basically, if the
; line collides with the plane, there should be a negative and positive distance.  make sense?
; If the line pierces the plane, it will have a negative distance and a positive distance,
; meaning that a point will be on one side of the plane, and one point on the other.  But we
; will do the check after this, first we need to get the distance of each point to the plane.

; Now, we need to use something called the plane equation to get the distance from each point.
; Here is the plane Equation:  (Ax + By + Cz + D = The distance from the plane)
; If "The distance from the plane" is 0, that means that the point is ON the plane, which all the polygon points should be.
; A, B and C is the Normal's X Y and Z values.  x y and z is the Point's x y and z values.
; "the Point" meaning one of the points of our line.  D is the distance that the plane
; is from the origin.  We just calculated that and stored it in "originDistance".
; Let's fill in the equation with our data:

; Get the distance from point1 from the plane using: Ax + By + Cz + D = (The distance from the plane)

;distance1 = ((vNormal.x * vLine[0].x)  +     // Ax +
;                     (vNormal.y * vLine[0].y)  +     // Bx +
;                     (vNormal.z * vLine[0].z)) + originDistance                     // Cz + D
            mov esi, pLine
            fld  vNormal.X
            fmul [esi].Vec3.X
            fld  vNormal.Y
            fmul [esi].Vec3.Y
            fld  vNormal.Z
            fmul [esi].Vec3.Z
            fadd
            fadd
            fadd foriginDistance
            fstp fdistance1 

; We just got the first distance from the first point to the plane, now let's get the second.
 
; Get the distance from point2 from the plane using Ax + By + Cz + D = (The distance from the plane)
 
;distance2 = ((vNormal.x * vLine[1].x)  +     // Ax +
;                     (vNormal.y * vLine[1].y)  +     // Bx +
;                     (vNormal.z * vLine[1].z)) + originDistance;                         // Cz + D
            add esi, sizeof Vec3
            fld  vNormal.X
            fmul [esi].Vec3.X
            fld  vNormal.Y
            fmul [esi].Vec3.Y
            fld  vNormal.Z
            fmul [esi].Vec3.Z
            fadd
            fadd
            fadd foriginDistance
            fstp fdistance2

; Ok, we should have 2 distances from the plane, from each point of our line.
; Remember what I said about an intersection?  If one is negative and one is positive,
; that means that they are both on either side of the plane.  So, all we need to do
; is multiply the 2 distances together, and if the result is less than 0, we intersection.
; This works because, any number times a negative number is always negative, IE (-1 * 1 = -1)
; If they are both positive or negative values then it will be above zero.

; Check to see if both point's distances are both negative or both positive
            fld fdistance1            ;if fdistance1 * fdistance2 >= 0
            fmul fdistance2
            fcomp r4_0_0
            __FJG @F
            return FALSE           ; Return false if each point has the same sign.  -1 and 1 would mean each point is on either side of the plane.  -1 -2 or 3 4 wouldn't...
@@:     
 return TRUE                ; The line intersected the plane, Return TRUE
IntersectedPlane endp


ClosestPointOnLine proc uses esi edi pA, pB, pPoint, pClosestPoint 
;// This function takes a line segment, vA to vB, then a point, vPoint.
;// We want to find the closet point on the line segment to our vPoint
;// out in space.  Either it is going to be one of the end points of the line,
;// or it is going to be somewhere between vA and vB.  This is a important
;// function when dealing with collision detection.

;// Here is how it works, it's a bit confusing at first, so you will need
;// to contemplate it a bit.  First, we want to grab a vector from "vA" to the point.
;// Then we want to get a normalized vector from "vA" to "vB".  We don't need the
;// full length of the line segment vector, we just want a direction.  That is why 
;// we normalize it.  Remember, this is important because we are going to be using 
;// the dot product coming up next.  So, now we have 2 vectors that form a pseudo corner
;// of a triangle on the plane of the line segment and the point.
;//
;// Next, we want to find the distance or "magnitude" of the line segment.  This is
;// done with a simple distance formula.  Then we use the dot "vVector2" with "vVector1".
;// By using the dot product, we can essentially project vVector1 onto the
;// line segments normalized vector, "vVector2".  If the result of the dot product is
;// 0, that means the vectors were perpendicular and had a 90 degree angle between them.
;// The 0 part is the distance the new projected vector is from the starting of vVector2.
;// If the result is a negative number, that means the angle between the 2 vectors
;// is greater than 90 degrees, which means that the closest point must be "vA" because
;// it's projected vector is on the outside of the line.  So, if the result is a positive
;// number, the projected vector is on the right side of "vA", but could be past the right
;// side of vB.  To test this, we make sure that the result of the dot product is NOT
;// greater than the distance "d".  If it is, then the closest point on the plane is
;// obviously vB.  
;//
;// So, we can find the closest point easily if it's one of the end points of the line
;// segment, but how do we find the point between the 2 end points?  This is simple.
;// Since we have the distance "t" from point "vA" (given to us from the dot product 
;// of the 2 vectors), we just use our vector that is going the direction of the
;// line segment, "vVector2", and multiply it by the distance scalar "t".  This will
;// create a vector going in the direction of the line segment, with a distance
;// (or magnitude) of the projected vector, "vVector1", is from from "vA".  We then add
;// this vector to "vA", which gives us the point on the line that is closest to our
;// point out in space, vPoint!  
;//
;// This is probably pretty hard to visualize with just comments, unless you have a good 
;// grasp of linear algebra.  
;

local vVector1:Vec3
local vVector2:Vec3
local vVector3:Vec3
local vClosestPoint:Vec3
local fDist:REAL4
local ft:REAL4

;// Create the vector from end point vA to our point vPoint.
    mov esi,pPoint
    mov edi,pA
    fld  [esi].Vec3.X
    fsub [edi].Vec3.X
    fstp vVector1.X
    fld  [esi].Vec3.Y
    fsub [edi].Vec3.Y
    fstp vVector1.Y
    fld  [esi].Vec3.Z
    fsub [edi].Vec3.Z
    fstp vVector1.Z

;// Create a normalized direction vector from end point vA to end point vB
    mov esi,pB
    fld  [esi].Vec3.X
    fsub [edi].Vec3.X
    fstp vVector2.X
    fld  [esi].Vec3.Y
    fsub [edi].Vec3.Y
    fstp vVector2.Y
    fld  [esi].Vec3.Z
    fsub [edi].Vec3.Z
    fstp vVector2.Z
    
    invoke Vec3Normalize, addr vVector2

;// Use the distance formula to find the distance of the line segment (or magnitude)
    invoke Vec3Distance, pA, pB
    fstp fDist

;// Using the dot product, we project the vVector1 onto the vector vVector2.
;// This essentially gives us the distance from our projected vector from vA.
    invoke Vec3Dot,addr vVector2, addr vVector1
    fstp ft

;// If our projected distance from vA, "t", is less than or equal to 0, it must
;// be closest to the end point vA.  We want to return this end point.
    fld ft                              ;   if (ft <= 0) 
    fcomp r4_0_0
    __FJG @F      
    mov esi,pA
    mov edi,pClosestPoint
    fld [esi].Vec3.X
    fstp [edi].Vec3.X
    fld [esi].Vec3.Y
    fstp [edi].Vec3.Y
    fld [esi].Vec3.Z
    fstp [edi].Vec3.Z
    ret

@@:
;// If our projected distance from vA, "t", is greater than or equal to the magnitude
;// or distance of the line segment, it must be closest to the end point vB.  So, return vB.
    fld ft                              ;    if (ft >= fDist) 
    fcomp fDist
    __FJL @F
    mov esi,pB
    mov edi,pClosestPoint
    fld [esi].Vec3.X
    fstp [edi].Vec3.X
    fld [esi].Vec3.Y
    fstp [edi].Vec3.Y
    fld [esi].Vec3.Z
    fstp [edi].Vec3.Z
    ret

@@: 
;// Here we create a vector that is of length ft and in the direction of vVector2
;vVector3 = vVector2 * t;
    lea esi,vVector2
    fld [esi].Vec3.X
    fmul ft
    fstp vVector3.X
    fld [esi].Vec3.Y
    fmul ft
    fstp vVector3.Y
    fld [esi].Vec3.Z
    fmul ft
    fstp vVector3.Z

;// To find the closest point on the line segment, we just add vVector3 to the original
;// end point vA.  
;vClosestPoint = vA + vVector3;
   mov esi,pA
    mov edi, pClosestPoint
   fld [esi].Vec3.X
   fadd vVector3.X
   fstp [edi].Vec3.X
   fld [esi].Vec3.Y
   fadd vVector3.Y
   fstp [edi].Vec3.Y
   fld [esi].Vec3.Z
   fadd vVector3.Z
   fstp [edi].Vec3.Z

;// Return the closest point on the line segment
    ret
ClosestPointOnLine endp


 ; 
 ; 
 ; /////////////////////////////////////////////////////////////////////////////////
 ; //
 ; // * QUICK NOTES * 
 ; //
 ; // That's all we need to find if a ray (line) and plane intersect.  Pretty simple eh?
 ; // I think it's not too complicated.  Once you understand the a cool math function
 ; // called the dot product, it starts to make sense.  We will learn more about this in
 ; // the next collision tutorial.  That is when stuff actually start getting complicated.
 ; // Right now, all we can collide with is a plane.  In the next tutorial we will be
 ; // able to just collide with the polygon, not just the plane the polygon is on.
 ; //  
 ; // Here are some of the more important steps to finding the intersection of a line and plane:
 ; // 
 ; // 1) First we need a polygon (at least 3 points) and a line segment.  We then find
 ; //    the normal of the polygon.
 ; // 
 ; // 2) Once we have the normal, we want to find the distance the plane is from the origin.
 ; //    We use the plane equation (Ax + By + Cz + D = 0) to find the distance.
 ; //   We want D, so we turn that into D = -(Ax + By + Cz)
 ; // 
 ; // 3) With the distance, we can now fill in the rest of the plane equation to find
 ; //    the distance a point is from the plane.  So (Ax + By + Cz + D = The distance from the plane)
 ; //    A B C is the plane's normal.X normal.Y normal.Z, and x y z is the point's x y z value.
 ; //    We get the first points distance, then get the second points distance.
 ; // 
 ; // 4) If we times the 2 distances of each point together, we either get a positive or negative number.
 ; //    If the number is negative, that means we collided because each distance had to be the opposite value.
 ; //    If the result is positive, that means that the 2 points were on the same side of the plane as each other.
 ; // 
 ; // That's it!
 ; // 
 ; // Let us know at www.GameTutorials.com if this was helpfull to you.  Any feedback is welcome.
 ; // 
 ; // 
 ; // Ben Humphrey (DigiBen)
 ; // Game Programmer
 ; // DigiBen@GameTutorials.com
 ; // Co-Web Host of www.GameTutorials.com
 ; //
