InitGL proc	
    _glClearColor 0.0f, 0.0f, 0.0f, 0.0f						; Clear the background colour to black
    _glClearDepth 1.0f											; Depth buffer setup
    invoke glDepthFunc, GL_LEQUAL								; Set type of depth test
    invoke glBlendFunc, GL_SRC_ALPHA, GL_ONE					; Select the type of blending
    invoke glShadeModel,GL_SMOOTH								; Enable smooth shading
    invoke glEnable, GL_TEXTURE_2D								; Enable texture mapping
    mov eax, 1  		
    ret
InitGL endp

ReSizeGLScene proc widthx:DWORD, heighty:DWORD
LOCAL ratio:GLdouble  
    .IF heighty == 0
       mov heighty, 1 ; prevent div by zero
    .ENDIF
    invoke glViewport, 0, 0, widthx, heighty
    invoke glMatrixMode, GL_PROJECTION
    invoke glLoadIdentity  		
    fild widthx
    fild heighty
    fdivp st(1),st(0)
    fstp ratio
    _gluPerspective 45.0f, ratio, 0.1f, 100.0f
    invoke glMatrixMode, GL_MODELVIEW
    invoke glLoadIdentity
    ret
ReSizeGLScene endp

CreateGLWindow proc WinTitle:DWORD,  WinBits:UINT, WinFullscreen:BOOL
LOCAL dwExStyle:DWORD, dwStyle:DWORD, PixelFormat:GLuint
LOCAL WindowRect:RECT, dmScreenSettings:DEVMODE, wc:WNDCLASS, pfd:PIXELFORMATDESCRIPTOR

    mov WindowRect.left,0
    mov WindowRect.top,0
    m2m WindowRect.right,WinWidth
    m2m WindowRect.bottom,WinHeight
    m2m fullscreen, WinFullscreen

    invoke GetModuleHandle,NULL
    mov hInstance,eax
    mov wc.style,CS_HREDRAW or CS_VREDRAW or CS_OWNDC
    mov wc.lpfnWndProc, offset WndProc
    mov wc.cbClsExtra,0
    mov wc.cbWndExtra,0
    m2m wc.hInstance,hInstance
    mov wc.hbrBackground,NULL
    mov wc.lpszMenuName,NULL
    mov wc.lpszClassName,offset txt_OpenGL
    invoke LoadIcon,NULL,IDI_WINLOGO
    mov wc.hIcon,eax
    invoke LoadCursor,NULL,IDC_ARROW
    mov wc.hCursor,eax

    ; Register the window class
    invoke RegisterClass,addr wc
    .IF !eax
        invoke MessageBox,NULL,addr txt_WC_Failed,addr txt_Error,MB_OK or MB_ICONEXCLAMATION
        mov eax,FALSE
        ret
    .ENDIF

    ; Set fullscreen, if appropriate
    .IF fullscreen
        ZeroMemory &dmScreenSettings,sizeof(dmScreenSettings)
        mov dmScreenSettings.dmSize,sizeof dmScreenSettings
        m2m dmScreenSettings.dmPelsWidth,WinWidth
        m2m dmScreenSettings.dmPelsHeight, WinHeight
        m2m dmScreenSettings.dmBitsPerPel, WinBits
        mov dmScreenSettings.dmFields,DM_BITSPERPEL or DM_PELSWIDTH or DM_PELSHEIGHT

        ; Try to set selected mode
        invoke ChangeDisplaySettings,addr dmScreenSettings,CDS_FULLSCREEN
        .IF eax != DISP_CHANGE_SUCCESSFUL
            ; Original code prompts user, and asks to set to window or exit. I'll just set to window mode
            mov fullscreen,FALSE
        .ENDIF
    .ENDIF

    ; Check if we are (still?) in fullscreen
    .IF fullscreen
        mov dwExStyle, WS_EX_APPWINDOW
        mov dwStyle,WS_POPUP
        invoke ShowCursor,FALSE
    .ELSE
        mov dwExStyle,WS_EX_APPWINDOW or WS_EX_WINDOWEDGE
        mov dwStyle, WS_OVERLAPPEDWINDOW 
    .ENDIF

    invoke AdjustWindowRectEx,addr WindowRect,dwStyle,FALSE,dwExStyle
    mov eax, WindowRect.left
    sub WindowRect.right,eax
    mov eax, WindowRect.top
    sub WindowRect.bottom, eax
	
    mov eax,dwStyle
    or eax,WS_CLIPSIBLINGS or WS_CLIPCHILDREN
    invoke CreateWindowEx,dwExStyle,addr txt_OpenGL,addr txt_Window_Title,eax,
                0,0,WindowRect.right,WindowRect.bottom,NULL,NULL,hInstance,NULL
    .IF !eax
        invoke KillGLWindow
        invoke MessageBox,NULL,txt_WindowCreateError,txt_Error,MB_OK or MB_ICONEXCLAMATION
        mov eax, FALSE
        ret
    .ENDIF
    mov hWnd,eax

    ZeroMemory &pfd,sizeof(PIXELFORMATDESCRIPTOR)
    mov pfd.nSize,sizeof(PIXELFORMATDESCRIPTOR)
    mov pfd.nVersion,1
    mov pfd.dwFlags,PFD_DRAW_TO_WINDOW or PFD_SUPPORT_OPENGL or PFD_DOUBLEBUFFER 
    mov pfd.iPixelType,PFD_TYPE_RGBA
    mov pfd.cColorBits,16
    mov pfd.cDepthBits,16
    mov pfd.dwLayerMask,PFD_MAIN_PLANE

    ; Try to get a device context
    invoke GetDC,hWnd
    .IF !eax
        invoke KillGLWindow
        invoke MessageBox,NULL,addr txt_GL_Context_Failed,addr txt_Error,MB_OK or MB_ICONEXCLAMATION
        mov eax,FALSE
        ret
    .ENDIF
    mov hDC,eax

    ; Select pixel format
    invoke ChoosePixelFormat,hDC,addr pfd
    .IF !eax
        invoke KillGLWindow
        invoke MessageBox,NULL,addr txt_PixelFormat_Failed,addr txt_Error,MB_OK or MB_ICONEXCLAMATION
        mov eax,FALSE
        ret
    .ENDIF
    mov PixelFormat,eax

    ; Set pixel format
    invoke SetPixelFormat,hDC,PixelFormat,addr pfd
    .IF !eax
        invoke KillGLWindow
        invoke MessageBox,NULL,addr txt_SetPixelFormat_Failed,addr txt_Error,MB_OK or MB_ICONEXCLAMATION
        mov eax,FALSE
        ret
    .ENDIF

    ; Get rendering context
    invoke wglCreateContext,hDC
    .IF !eax
        invoke KillGLWindow
        invoke MessageBox,NULL,addr txt_RC_Failed,addr txt_Error,MB_OK or MB_ICONEXCLAMATION
        mov eax,FALSE
        ret
    .ENDIF
    mov hRC,eax

    ; Activate rendering context
    invoke wglMakeCurrent,hDC,hRC
    .IF !eax
        invoke KillGLWindow
        invoke MessageBox,NULL,addr txt_ActivateRC_Failed,addr txt_Error,MB_OK or MB_ICONEXCLAMATION
        mov eax,FALSE
        ret
    .ENDIF

    invoke ShowWindow,hWnd,SW_SHOW
    invoke SetForegroundWindow,hWnd
    invoke SetFocus,hWnd
    invoke ReSizeGLScene,WinWidth,WinHeight

    invoke InitGL
    .IF !eax
        invoke KillGLWindow
        invoke MessageBox,NULL,addr txt_GLInit_Failed,addr txt_Error,MB_OK or MB_ICONEXCLAMATION
        mov eax,FALSE
        ret
    .ENDIF

    mov eax,TRUE
    ret
CreateGLWindow endp

KillGLWindow proc
    .IF fullscreen
        invoke ChangeDisplaySettings,NULL,0
        invoke ShowCursor,TRUE
    .ENDIF
	
    .IF hRC
        invoke wglMakeCurrent,NULL,NULL
        invoke wglDeleteContext,hRC
        mov hRC,NULL
    .ENDIF
	
    .IF hDC
        invoke ReleaseDC,hWnd,hDC
        mov hDC,NULL
    .ENDIF
	
    .IF hWnd
        invoke DestroyWindow,hWnd
        mov hWnd,NULL
    .ENDIF
	
    invoke UnregisterClass,addr txt_OpenGL,hInstance
    mov hInstance,NULL
	
    ret
KillGLWindow endp