.586
.model flat, stdcall
option casemap:none

;This OpenGL example supports:
;Asynchronous keyboard
;Escape to quit
;F1 to switch screen mode (full/windowed)
;Resizing in Windowed mode
;HighPerformance Timer

;It will be a demonstration of Quat-based 1stPerson Camera, hopefully with frustum culling
;Perhaps later add switch for first/thirdperson modes, and slerp the cam between them

; INCLUDES * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\gdi32.inc
include \masm32\include\masm32.inc
include gl.def
include glu.def
include winextra.def

includelib c:\masm32\lib\kernel32.lib
includelib c:\masm32\lib\user32.lib
includelib c:\masm32\lib\gdi32.lib
includelib c:\masm32\lib\opengl32.lib
includelib c:\masm32\lib\glu32.lib
includelib c:\masm32\lib\masm32.lib

; Missing from include files * * * * * * * * * * * * * * * * * * * * * 
DM_BITSPERPEL       = 00040000h
DM_PELSWIDTH        = 00080000h
DM_PELSHEIGHT       = 00100000h
ANTIALIASED_QUALITY = 4
WGL_FONT_POLYGONS 	= 1

; PROTOTYPES * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
WinMain                      PROTO :HWND, :UINT, :WPARAM, :LPARAM
CreateGLWindow        PROTO :DWORD, :UINT, :BOOL
KillGLWindow             PROTO

.data
;
txt_Window_Title                 db "Homer's OpenGL TestBed",0
;
txt_Title_Fullscn                  db "Graphics mode",0
txt_Query_Fullscn               db "Do you want to run in fullscreen?",0
;
txt_WC_Failed	                     db "Failed to registed window class",0
txt_GL_Context_Failed         db "Failed to create a GL device context",0
txt_RC_Failed                       db "Failed to create a GL rendering context",0
txt_PixelFormat_Failed        db "Failed to find suitable PixelFormat",0
txt_ActivateRC_Failed	          db "Failed to activate GL rendering context",0
txt_GLInit_Failed                  db "Initialisation failed",0
txt_SetPixelFormat_Failed   db "Failed to set PixelFormat",0
txt_WindowCreateError        db "Window creation error",0
txt_Error                               db "Error",0
txt_OpenGL                          db "OpenGL",0

; UNINITIALISED DATA * * * * * * * * * * * * * * * * * * * * * * * * * 
.data?
hRC          HGLRC   ?
hDC          HDC         ?
hWnd       HWND        ?
hInstance HINSTANCE ?
;
keys               db 256 dup (?)             ; keypress status
fullscreen       BOOL  ?                      ; fullscreen toggle
active             BOOL  ?                      ; window active toggle/status


.data
WinWidth dd 640
WinHeight dd 480

r4_0_0 REAL4 0.0f
r4_0_1 REAL4 0.10f
r4_0_25 REAL4 0.25f
r4_1_0 REAL4 1.0f
r4_m1_0 REAL4 -1.0f
r4_0_5 REAL4 0.5f
r4_2_0 REAL4 2.0f
r4_500_0 REAL4 10000.0f
r4_m5_0 REAL4 -5.0f

fTimeElapsed REAL4 0.0f
blah REAL8 0.0f

bMoveForwards dd FALSE
bMoveBackwards dd FALSE
bMoveLeft dd FALSE
bMoveRight dd FALSE

; BUGS BEGIN HERE * * * * * * * * * * * * * * * * * * * * * * * * * * 
.code
__DEBUG__ equ 0

include \masm32\include\macros.inc                          ;<-- Homer's general-purpose macro include
include \masm32\oopsocket\classes\class32.inc       ;<-- ATC OOP SUPPORT
include GLBase.inc                                                      ;<-- OpenGL stuff
include Code_3DMath.inc                                            ;<-- 3D Math functions
;include CFrustum.inc
;include Camera.inc
include \masm32\include\winmm.inc
includelib \masm32\lib\winmm.lib
include Timer_CodeBase.inc

include CQuaternion.inc                     ;<-- Quaternion support

.data

buffy db 256 dup (0)
.code

start:
invoke Timer,TIMER_START
fstp blah
invoke Timer, TIMER_GETELAPSEDTIME
fstp fTimeElapsed

invoke GetModuleHandle,0
mov hInstance, eax
invoke WinMain,hInstance,0,0,0
invoke ExitProcess, eax
;** END

.code
;=========================================================================
WinMain proc hInst, hPrevInst, CmdLine, CmdShow
LOCAL msg:MSG, done:UINT
local buf[256]:BYTE

; Check if we should start in full screen
    invoke MessageBox,NULL,addr	txt_Query_Fullscn,addr txt_Title_Fullscn,MB_YESNO or MB_ICONQUESTION
    .IF eax == IDNO
        mov fullscreen,FALSE
    .ELSE
        mov fullscreen,TRUE
    .ENDIF

    invoke CreateGLWindow,addr txt_Window_Title,16,fullscreen
    .IF !eax
        ret
    .ENDIF


.data
vUp Vec3 <0.0f, 1.0f, 0.0f>
vPos Vec3 <0.0f, 0.00f, 0.0f>
vLookAt Vec3 <0.0f, 0.0f, 1.0f>
.code

    mov done,FALSE
    .WHILE !done
    invoke PeekMessage,addr	msg,NULL,0,0,PM_REMOVE
    .IF eax
        .IF msg.message == WM_QUIT
            mov done,TRUE
        .ELSE
            invoke TranslateMessage,addr msg
            invoke DispatchMessage,addr msg
        .ENDIF
    .ELSE
;---- BEGIN RENDERING CODE ----
        .if keys[VK_UP]==TRUE
            mov bMoveForwards,TRUE
        .else
            .if bMoveForwards == TRUE
                mov bMoveForwards , FALSE
            .endif
        .endif

        .if keys[VK_DOWN]==TRUE
            mov bMoveBackwards,TRUE
        .else
            .if bMoveBackwards== TRUE
                mov bMoveBackwards, FALSE
            .endif
        .endif

        .if keys[VK_LEFT]==TRUE
            mov bMoveLeft,TRUE
        .else
            .if bMoveLeft== TRUE
                mov bMoveLeft, FALSE
            .endif
        .endif

        .if keys[VK_RIGHT]==TRUE
            mov bMoveRight,TRUE
        .else
            .if bMoveRight== TRUE
                mov bMoveRight, FALSE
            .endif
        .endif

.data
fp1000 REAL4 1000.0f
dwElapsedTicks dd 0
.code
        invoke Timer, TIMER_GETELAPSEDTIME
        fst fTimeElapsed
        fmul fp1000
        fistp dwElapsedTicks 
        
        invoke wsprintf,addr buffy, CTEXT("%lu Ticks Elapsed"),dwElapsedTicks 
        invoke SetWindowText, hWnd, addr buffy

      ;  invoke DrawGLScene      

	invoke glClear, (GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT)
.data
fpm1p5 REAL4 -1.5f
fpm6 REAL4 -6.0f
fp0 REAL4 0.0f
fp1 REAL4 1.0f
fpm1 REAL4 -1.0f
.code
;	invoke glLoadIdentity

invoke glPushMatrix
	invoke glTranslatef , r4_0_0, r4_0_0 ,r4_m5_0;				// Move Left 1.5 Units And Into The Screen 6.0

            invoke glColor3f,r4_1_0 ,r4_1_0,r4_1_0		;	// Set The Color To B
	invoke glBegin,GL_QUADS;					// Draw A Quad
  		invoke glColor3f,fp1,fp0,fp0		;	// Set The Color To Red
		invoke glVertex3f,r4_m1_0, r4_1_0, r4_0_0;				     // Top Left
  		invoke glColor3f,fp0,fp1,fp0		;	// Set The Color To G
		invoke glVertex3f, r4_1_0, r4_1_0, r4_0_0;				     // Top Right
  		invoke glColor3f,fp0,fp0,fp1		;	// Set The Color To B
		invoke glVertex3f, r4_1_0,r4_m1_0, r4_0_0;				     // Bottom Right
  		invoke glColor3f,fp1,fp1,fp1		;	// Set The Color To W
		invoke glVertex3f,r4_m1_0,r4_m1_0, r4_0_0;			     // Bottom Left
	invoke glEnd;	
invoke glPopMatrix

        invoke SwapBuffers,hDC  ;<-- switching the front and back buffers displays the rendered frame
;----- END RENDERING CODE -----
	  		
; KEYBOARD - Check for some important keystrokes
        .IF active && keys[VK_ESCAPE]
            mov done, 1        
        .ENDIF

        .IF keys[VK_F1]
            mov keys[VK_F1],FALSE
            invoke KillGLWindow
            xor fullscreen, 1
            invoke CreateGLWindow,addr txt_Window_Title,16,fullscreen
            .IF !eax
                mov eax,FALSE
            .ENDIF       
        .ENDIF

    .ENDIF
    .ENDW                           ;End of Main Loop (User has decided to QUIT TO WINDOWS)
    invoke KillGLWindow
    mov eax,msg.wParam
    ret
WinMain endp

WndProc proc hWind:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
local charz[2]:BYTE
    .IF uMsg == WM_ACTIVATE
        mov eax,wParam
        .IF !ah
            mov active,TRUE
        .ELSE
            mov active,FALSE
        .ENDIF
        return NULL
    .ELSEIF uMsg==WM_SYSCOMMAND
        .IF wParam == SC_SCREENSAVE or SC_MONITORPOWER
            xor eax, eax
            ret
        .ENDIF
    .ELSEIF uMsg==WM_CLOSE
        invoke PostQuitMessage,0
        xor eax, eax
        ret
    .ELSEIF uMsg==WM_KEYDOWN
        mov eax,wParam
        mov keys[eax],TRUE
        xor eax, eax
        ret
    .ELSEIF uMsg==WM_KEYUP
        mov eax,wParam
        mov keys[eax],FALSE
        xor eax, eax
        ret

    .ELSEIF uMsg==WM_SIZE
        mov eax,lParam
        mov ebx,eax
        and eax,0000FFFFh
        shr ebx,16
        invoke ReSizeGLScene,eax,ebx
        xor eax, eax
        ret
    
    .ENDIF
    invoke DefWindowProc,hWind,uMsg,wParam,lParam
    ret
WndProc endp



end start