;-----------------------------------------------------------------------------
;
; Desc: This will use the Performance Counter if it's available, otherwise it'll use timeGetTime.
;
; Original:   http://www.scrontsoft.com
;                   scronty@scrontsoft.com
;
;-----------------------------------------------------------------------------

;
;NOTE: Timer *ALWAYS* returns the result as a QWORD on the FPU stack
;       Remember to:
;       "fstp fpdummy"
;       after using this PROC if you don't need the returned value,
;       otherwise the fpu stack will overflow.
;

    
    TIMER_RESET                     EQU 1
    TIMER_START                     EQU 2
    TIMER_STOP                      EQU 3
    TIMER_ADVANCE                   EQU 4
    TIMER_GETABSOLUTETIME           EQU 5
    TIMER_GETAPPTIME                          EQU 6     
    TIMER_GETELAPSEDTIME                 EQU 7
    TIMER_GETCURRENTELAPSEDTIME EQU 8
    
    Timer PROTO :DWORD
;-----------------------------------------------------------------------------
; Name: Timer
; Desc: Performs timer opertations. Use the following commands:
;          TIMER_RESET             - to reset the timer
;          TIMER_START             - to start the timer
;          TIMER_STOP               - to stop (or pause) the timer
;          TIMER_ADVANCE         - to advance the timer by 0.1 seconds
;          TIMER_GETABSOLUTETIME - to get the absolute system time
;          TIMER_GETAPPTIME      - to get the current time
;          TIMER_GETELAPSEDTIME  - to get the time that elapsed between TIMER_GETELAPSEDTIME calls
;          TIMER_GETCURRENTELAPSEDTIME -Returns ElapsedTime (without updating anything)
;-----------------------------------------------------------------------------

Timer PROC command:DWORD
LOCAL dwtemp:DWORD
LOCAL fptemp:FLOAT
LOCAL TIMERPC_qwTicksPerSec:LARGE_INTEGER
LOCAL PartLow:DWORD
LOCAL PartHigh:DWORD
LOCAL TIMERPC_qwTime:QWORD
LOCAL TIMERPC_fAppTime:DWORD

.DATA
    bTimerInitialized               DWORD       FALSE
    bUsingQPF                       DWORD       FALSE
    TIMERPC_llQPFTicksPerSec        QWORD               0.0f
    TIMERPC_llStopTime              QWORD               0.0f
    TIMERPC_llLastElapsedTime       QWORD               0.0f
    TIMERPC_llBaseTime              QWORD               0.0f
    TIMERPC_fTime                   DWORD       0.0f
    TIMERPC_fElapsedTime            DWORD       0.0f
.CODE

;   Initialize the timer
    .IF bTimerInitialized == FALSE

        mov bTimerInitialized, TRUE

;   Use QueryPerformanceFrequency() to get frequency of timer.  If QPF is
;   not supported, we will timeGetTime() which returns milliseconds.

        INVOKE QueryPerformanceFrequency, ADDR TIMERPC_qwTicksPerSec
        mov bUsingQPF, eax
    
        .IF bUsingQPF == TRUE

            fld    qword ptr [TIMERPC_qwTicksPerSec]
            fstp   qword ptr [TIMERPC_llQPFTicksPerSec]
            
        .ENDIF      ;bUsingQPF == TRUE
        
    .ENDIF      ;bTimerInitialized == FALSE


    .IF bUsingQPF == TRUE

;   Get either the current time or the stop time, depending
;   on whether we're stopped and what command was sent

        fld qword ptr [TIMERPC_llStopTime]
        fldz
        fcompp
jne @F
        mov eax, command
        cmp eax, TIMER_START
jne @F
        mov eax, command
        cmp eax, TIMER_GETABSOLUTETIME
jne @F

        fld qword ptr [TIMERPC_llStopTime]
        fstp qword ptr [TIMERPC_fTime]
        
jmp Timercont1

@@:

        INVOKE QueryPerformanceCounter, ADDR TIMERPC_qwTime
            

Timercont1:

;   Return the current elapsed time (without updating anything)
        .IF command == TIMER_GETCURRENTELAPSEDTIME

            fld qword ptr [TIMERPC_qwTime]
            fsub qword ptr [TIMERPC_llLastElapsedTime]
            fdiv qword ptr [TIMERPC_llQPFTicksPerSec]

            ret

        .ENDIF

;   Return the elapsed time
        .IF command == TIMER_GETELAPSEDTIME

            fld qword ptr [TIMERPC_qwTime]
            fsub qword ptr [TIMERPC_llLastElapsedTime]
            fdiv qword ptr [TIMERPC_llQPFTicksPerSec]
            fstp dword ptr [TIMERPC_fElapsedTime]
            
            fld qword ptr [TIMERPC_qwTime]
            fstp qword ptr [TIMERPC_llLastElapsedTime]

            fld dword ptr [TIMERPC_fElapsedTime]
            ret

        .ENDIF
        
;   Return the current time

        .IF command == TIMER_GETAPPTIME

            fld qword ptr [TIMERPC_qwTime]
            fsub qword ptr [TIMERPC_llBaseTime]
            fdiv qword ptr [TIMERPC_llQPFTicksPerSec]
            fst dword ptr [TIMERPC_fAppTime]
            ret

        .ENDIF
    
;   Reset the timer

        .IF command == TIMER_RESET

            fld qword ptr [TIMERPC_qwTime]
            fstp qword ptr [TIMERPC_llBaseTime]
            
            fld qword ptr [TIMERPC_qwTime]
            fstp qword ptr [TIMERPC_llLastElapsedTime]

            fldz
            ret

        .ENDIF
    
;   Start the timer

        .IF command == TIMER_START

            fld qword ptr [TIMERPC_llBaseTime]
            fld qword ptr [TIMERPC_qwTime]
            fsub qword ptr [TIMERPC_llStopTime]
            fadd
            fstp qword ptr [TIMERPC_llBaseTime]
            
            fldz
            fstp qword ptr [TIMERPC_llStopTime]
            
            fld qword ptr [TIMERPC_qwTime]
            fstp qword ptr [TIMERPC_llLastElapsedTime]

            fldz
            ret

        .ENDIF
        
;   Stop the timer

        .IF command == TIMER_STOP

            fld qword ptr [TIMERPC_qwTime]
            fstp qword ptr [TIMERPC_llStopTime]
            
            fld qword ptr [TIMERPC_qwTime]
            fstp qword ptr [TIMERPC_llLastElapsedTime]

            fldz
            ret

        .ENDIF
    
;   Advance the timer by 1/10th second

        .IF command == TIMER_ADVANCE

            fld qword ptr [TIMERPC_llStopTime]
            fld qword ptr [TIMERPC_llQPFTicksPerSec]
            mov dwtemp, 10
            fidiv dwtemp
            fadd
            fstp qword ptr [TIMERPC_llStopTime]

            fldz
            ret

        .ENDIF

        .IF command == TIMER_GETABSOLUTETIME

            fld qword ptr [TIMERPC_qwTime]
            fdiv qword ptr [TIMERPC_llQPFTicksPerSec]
            fstp qword ptr [TIMERPC_fTime]
            
            fld dword ptr [TIMERPC_fTime]
            ret

        .ENDIF


            fld1
            fchs
            ret     ; (-1) Invalid command specified

    .ELSE

;   Get the time using "timeGetTime"

.DATA    
    TIMER_fLastElapsedTime        DWORD       0.0f
    TIMER_fBaseTime               DWORD       0.0f
    TIMER_fStopTime               DWORD       0.0f
    TIMER_fTime                   DWORD       0.0f
    TIMER_fElapsedTime            DWORD       0.0f
.CODE

;   Get either the current time or the stop time, depending
;   on whether we're stopped and what command was sent

        fld dword ptr [TIMER_fStopTime]
        fldz
        fcompp
jne @F
        mov eax, command
        cmp eax, TIMER_START
jne @F
        mov eax, command
        cmp eax, TIMER_GETABSOLUTETIME
jne @F

        fld dword ptr [TIMER_fStopTime]
        fstp dword ptr [TIMER_fTime]
        
jmp Timercont2

@@:

        INVOKE timeGetTime
        mov dwtemp, eax
        fild dwtemp
        mov dwtemp, 1000
        fld1
        fidiv dwtemp
        fmul
        fstp dword ptr [TIMER_fTime]

Timercont2:

;   Return the elapsed time

        .IF command == TIMER_GETELAPSEDTIME

            fld dword ptr [TIMER_fTime]
            fsub dword ptr [TIMER_fLastElapsedTime]
            fstp dword ptr [TIMER_fElapsedTime]
            
            fld dword ptr [TIMER_fTime]
            fstp dword ptr [TIMER_fLastElapsedTime]

            fld dword ptr [TIMER_fElapsedTime]
            ret

        .ENDIF
            
;   Return the current time

        .IF command == TIMER_GETAPPTIME

            fld dword ptr [TIMER_fTime]
            fsub dword ptr [TIMER_fBaseTime]
            ret

        .ENDIF
    
;   Reset the timer

        .IF command == TIMER_RESET

            fld dword ptr [TIMER_fTime]
            fst dword ptr [TIMER_fBaseTime]
            fstp dword ptr [TIMER_fLastElapsedTime]
            
            fldz
            ret

        .ENDIF
    
;   Start the timer

        .IF command == TIMER_START

                fld dword ptr [TIMER_fBaseTime]
                fld dword ptr [TIMER_fTime]
                fsub dword ptr [TIMER_fStopTime]
                fadd
                fstp dword ptr [TIMER_fBaseTime]
                
                fldz
                fstp dword ptr [TIMER_fStopTime]
                
                fld dword ptr [TIMER_fTime]
                fstp dword ptr [TIMER_fLastElapsedTime]
                
            fldz
            ret
            
        .ENDIF
    
;   Stop the timer

        .IF command == TIMER_STOP

            fld dword ptr [TIMER_fTime]
            fstp dword ptr [TIMER_fStopTime]

            fldz
            ret

        .ENDIF
    
;   Advance the timer by 1/10th second

        .IF command == TIMER_ADVANCE

            fld dword ptr [TIMER_fStopTime]
            mov dwtemp, 10
            fld1
            fidiv dwtemp
            fadd
            fstp dword ptr [TIMER_fStopTime]

            fldz
            ret

        .ENDIF

        .IF command == TIMER_GETABSOLUTETIME

            fld dword ptr [TIMER_fTime]
            ret

        .ENDIF

        fld1
        fchs
        ret     ; (-1) Invalid command specified

    .ENDIF

    ret
Timer ENDP
